<?php
defined('PF_VERSION') OR exit('Access denied');
$mail = new Pf_Mail();
$referer = !empty($_GET['ref']) ? urldecode($_GET['ref']) : public_base_url();
$form_displayname = array('name' => 'displayname', 'placeholder' => __('Display Name', 'user'));
$form_username = array('name' => 'username', 'placeholder' => __('Username', 'user'));
$form_email = array('name' => 'email', 'placeholder' => __('Email', 'user'));
$settings = Pf::setting();
$logintimes = $settings->get_element_value('pf_user', 'login_attemps');
$allow = $settings->get_element_value('pf_user', 'allow_reg');
if (!is_login()) {
    $login = Pf::auth();
    if (!empty($_POST)) {
        if ($_POST['type'] == 'login') {
            $error = '';
            if (!empty($_POST['username'])) {
                if ($login->valid_login($_POST['username']) < time()) {
                    if (!empty($_POST['password'])) {
                        $info = $login->login($_POST['username'], $_POST['password']);
                        if (is_array($info)) {
                            $active = $info['user_activation'];
                            if ($active == 1) {
                                if (isset($_POST['remember']) && $_POST['remember'] == 1) {
                                    $login->set_cookie('id', $info['uid'],360000);
                                }
                                $login->update_login($info['uid']);
                                $status = 'success';
                            } else {
                                $error = __('This account is not activated yet! Please check email or contact Administrator. Thanks! ', 'user') . "<br/>";
                            }
                        } else {
                            if (!empty($logintimes)) {
                                $login_fail = !empty($_COOKIE['logintimes']) ? ($_COOKIE['logintimes'] + 1 ) : 1;
                                setcookie("logintimes",$login_fail,time() + 3000);
                                $error .= __('Wrong username or password', 'user') . ' (' . $login_fail . '/' . $logintimes . __('times', 'user') . ')<br/>';
                                if (isset($_COOKIE['logintimes']) && $_COOKIE['logintimes'] >= $logintimes - 1) {
                                    $error .= __("Login Failed ", "user") . $logintimes . __(" times. Please wait 30 minutes to retry!", 'user') . "<br/>";
                                    $login->login_attemp($_POST['username']);
                                    setcookie("logintimes",$login_fail,time() + 3000);
                                }
                            } else {
                                $error.= __('Wrong username or password', 'user') . "<br/>";
                            }
                        }
                    } else
                        $error .= __('Please enter your password', 'user') . "<br/>";
                }
                else {
                    $error .= __("Login Failed " . $logintimes . " times. Please wait 30 minuste to retry!", 'user') . "<br/>";
                }
            } else
                $error .= __('Please enter your username', 'user') . "<br/>";
            if (!empty($error)) {
                $status = 'fail';
                die($error);
            } else {
                die($status);
            }
            exit();
        }
    }
    require_once 'views/views-login.php';
} else
    header('location: ' . public_base_url());